<!doctype html>
<html lang="bn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ env('APP_NAME') }} - Level {{ $level }}</title>

    <link rel="icon" href="/smartlab/smartlab.png" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        body {
            background-color: var(--primary-bg);
            font-family: 'Montserrat', 'Noto Sans Bengali', sans-serif;
            color: var(--text-primary);
            margin: 0;
            padding: 0;
        }

        main {
            max-width: 500px;
            margin: auto;
            padding-bottom: 20px;
        }

        .navbar {
            background: var(--secondary-bg);
            color: var(--accent-gold);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
            padding: 16px 20px;
            position: sticky;
            top: 0;
            z-index: 100;
            display: flex;
            align-items: center;
            border-bottom: 1px solid var(--border-color);
        }

        .navbar .left a {
            color: var(--accent-gold);
            font-weight: 600;
            text-decoration: none;
            font-size: 1rem;
            display: flex;
            align-items: center;
            padding: 8px 12px;
            border-radius: 8px;
            transition: var(--transition);
        }

        .navbar .left a:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: scale(1.05);
        }

        .navbar .left a i {
            margin-right: 8px;
            font-size: 1.2rem;
        }

        .navbar .center {
            flex-grow: 1;
            text-align: center;
            font-weight: 700;
            font-size: 1.3rem;
            color: var(--accent-gold);
            user-select: none;
        }

        .container {
            padding: 20px 15px;
        }

        .team-header {
            font-size: 1.4rem;
            font-weight: 700;
            color: var(--text-primary);
            padding: 20px;
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            text-align: center;
            user-select: none;
            background: var(--card-bg);
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }

        .team-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .level-badge {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            padding: 6px 12px;
            border-radius: 20px;
            font-weight: 700;
            font-size: 0.9rem;
            margin-left: 10px;
        }

        .stats-row {
            display: flex;
            justify-content: space-around;
            background: var(--card-bg);
            padding: 20px;
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
        }

        .stat-item {
            text-align: center;
            flex: 1;
        }

        .stat-label {
            font-size: 0.9rem;
            color: var(--text-secondary);
            margin-bottom: 8px;
        }

        .stat-value {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--accent-gold);
        }

        .member-card {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 15px;
            border: 1px solid var(--border-color);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .member-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .member-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.2);
            border-color: var(--accent-gold);
        }

        .member-body {
            padding: 20px;
            display: flex;
            align-items: center;
        }

        .serial-badge {
            font-size: 0.85rem;
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            padding: 8px 12px;
            border-radius: 50%;
            display: inline-block;
            width: 36px;
            height: 36px;
            line-height: 20px;
            text-align: center;
            margin-right: 15px;
            font-weight: 700;
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
            transition: var(--transition);
        }

        .member-card:hover .serial-badge {
            transform: scale(1.1);
        }

        .member-info {
            flex: 1;
        }

        .member-info p {
            margin-bottom: 8px;
            font-size: 0.95rem;
            color: var(--text-primary);
        }

        .member-info strong {
            color: var(--accent-gold);
        }

        .empty-state {
            text-align: center;
            padding: 50px 20px;
            color: var(--text-muted);
            background: var(--card-bg);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
        }

        .empty-state i {
            font-size: 48px;
            color: var(--accent-gold);
            margin-bottom: 15px;
            display: block;
        }

        /* Level specific colors */
        .level-1 .team-header {
            border-left: 4px solid #00ff00;
        }

        .level-2 .team-header {
            border-left: 4px solid #ff4444;
        }

        .level-3 .team-header {
            border-left: 4px solid #aa00ff;
        }

        @media (max-width: 480px) {
            .container {
                padding: 15px 10px;
            }
            
            .team-header {
                padding: 15px;
                font-size: 1.2rem;
            }
            
            .stats-row {
                padding: 15px;
            }
            
            .stat-value {
                font-size: 1.3rem;
            }
            
            .member-body {
                padding: 15px;
            }
            
            .serial-badge {
                width: 32px;
                height: 32px;
                line-height: 16px;
                margin-right: 12px;
            }
        }
    </style>
</head>

<body>
    <main>
        <div class="navbar">
            <div class="left">
                <a href="{{ route('user.invite') }}">
                    <i class="fas fa-arrow-left"></i> ফিরে যান
                </a>
            </div>
            <div class="center"><i class="fas fa-users me-2"></i>টিম লিস্ট</div>
        </div>

        <div class="container level-{{ $level }}">
            <div class="team-header">
                <i class="fas fa-user-friends me-2"></i>অধস্তন ব্যবহারকারীরা
                <span class="level-badge">LV {{ $level }}</span>
            </div>

            <div class="stats-row">
                <div class="stat-item">
                    <div class="stat-label">মোট অধস্তন</div>
                    <div class="stat-value">{{ $level_users->count() ?? 0 }}</div>
                </div>
                <div class="stat-item">
                    <div class="stat-label">প্রচার আয়</div>
                    <div class="stat-value">{{ price($commission_for_level ?? 0) }}</div>
                </div>
            </div>

            <div class="members-list">
                @forelse($level_users as $member)
                    <div class="member-card">
                        <div class="member-body">
                            <span class="serial-badge">{{ $loop->iteration }}</span>
                            <div class="member-info">
                                <p><strong><i class="fas fa-phone me-2"></i>ফোন:</strong> {{ $member->phone ?? 'N/A' }}</p>
                                <p><strong><i class="fas fa-calendar me-2"></i>রেজিস্ট্রেশন:</strong> {{ $member->created_at->format('d M, Y') }}</p>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="empty-state">
                        <i class="fas fa-users-slash"></i>
                        <p>এই লেভেলে কোনো সদস্য পাওয়া যায়নি।</p>
                    </div>
                @endforelse
            </div>
        </div>
    </main>

    <script>
        // Add interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.member-card');
            
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-3px)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });

            const badges = document.querySelectorAll('.serial-badge');
            badges.forEach(badge => {
                badge.addEventListener('mouseenter', function() {
                    this.style.transform = 'scale(1.1)';
                });
                
                badge.addEventListener('mouseleave', function() {
                    this.style.transform = 'scale(1)';
                });
            });

            // Add click effect to navbar back button
            const backButton = document.querySelector('.navbar .left a');
            backButton.addEventListener('click', function() {
                this.style.transform = 'scale(0.95)';
                setTimeout(() => {
                    this.style.transform = '';
                }, 150);
            });
        });
    </script>
</body>
</html>