<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{env('APP_NAME')}} - সাপোর্ট</title>

    <link rel="icon" href="/smartlab/smartlab.png" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Montserrat', sans-serif;
        }

        body {
            background-color: var(--primary-bg);
            color: var(--text-primary);
            min-height: 100vh;
            padding-bottom: 80px;
        }

        main {
            max-width: 500px;
            margin: auto;
            padding: 20px;
        }

        .navbar {
            background: var(--secondary-bg);
            color: var(--accent-gold);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
            padding: 16px 20px;
            position: sticky;
            top: 0;
            z-index: 100;
            display: flex;
            justify-content: center;
            align-items: center;
            border-bottom: 1px solid var(--border-color);
        }

        .navbar .left a {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--accent-gold);
            font-size: 16px;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 12px;
            border-radius: 8px;
            transition: var(--transition);
        }

        .navbar .left a:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: translateY(-50%) scale(1.05);
        }

        .navbar .center {
            font-weight: 700;
            font-size: 18px;
            color: var(--accent-gold);
        }

        .support-container {
            padding: 20px 0;
        }

        .support-card {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 20px;
            padding: 25px;
            transition: var(--transition);
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }

        .support-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .support-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(255, 215, 0, 0.2);
            border-color: var(--accent-gold);
        }

        .support-header {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }

        .support-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: rgba(255, 215, 0, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            border: 2px solid var(--accent-gold);
            transition: var(--transition);
        }

        .support-card:hover .support-icon {
            transform: scale(1.1);
            background: rgba(255, 215, 0, 0.2);
        }

        .support-icon i {
            font-size: 20px;
            color: var(--accent-gold);
        }

        .support-title {
            font-size: 18px;
            color: var(--accent-gold);
            font-weight: 600;
            margin-bottom: 5px;
        }

        .support-description {
            font-size: 14px;
            color: var(--text-secondary);
            line-height: 1.5;
        }

        .contact-info {
            background: var(--secondary-bg);
            padding: 15px;
            border-radius: 10px;
            margin-top: 15px;
            border: 1px solid var(--border-color);
        }

        .contact-item {
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 8px;
            transition: var(--transition);
            margin-bottom: 8px;
        }

        .contact-item:last-child {
            margin-bottom: 0;
        }

        .contact-item:hover {
            background: rgba(255, 215, 0, 0.1);
        }

        .contact-item i {
            color: var(--accent-gold);
            margin-right: 12px;
            font-size: 16px;
            width: 20px;
            text-align: center;
        }

        .contact-item span {
            color: var(--text-secondary);
            font-size: 14px;
        }

        .action-btn {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            border: none;
            padding: 12px 20px;
            border-radius: 10px;
            font-weight: 600;
            font-size: 14px;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
            width: 100%;
            margin-top: 15px;
        }

        .action-btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.5);
        }

        .faq-section {
            margin-top: 30px;
        }

        .faq-item {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            margin-bottom: 15px;
            border: 1px solid var(--border-color);
            overflow: hidden;
            transition: var(--transition);
        }

        .faq-item:hover {
            border-color: var(--accent-gold);
        }

        .faq-question {
            padding: 18px 20px;
            background: var(--secondary-bg);
            cursor: pointer;
            display: flex;
            justify-content: between;
            align-items: center;
            transition: var(--transition);
        }

        .faq-question:hover {
            background: rgba(255, 215, 0, 0.1);
        }

        .faq-question span {
            font-weight: 600;
            color: var(--text-primary);
            flex: 1;
        }

        .faq-question i {
            color: var(--accent-gold);
            transition: var(--transition);
        }

        .faq-answer {
            padding: 0 20px;
            max-height: 0;
            overflow: hidden;
            transition: var(--transition);
            color: var(--text-secondary);
            font-size: 14px;
            line-height: 1.6;
        }

        .faq-item.active .faq-answer {
            padding: 20px;
            max-height: 500px;
        }

        .faq-item.active .faq-question i {
            transform: rotate(180deg);
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            width: 100%;
            display: flex;
            justify-content: space-around;
            background: var(--secondary-bg);
            border-top: 1px solid var(--border-color);
            padding: 12px 0;
            z-index: 1000;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
            max-width: 500px;
            margin: 0 auto;
            left: 0;
            right: 0;
        }

        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: var(--text-muted);
            font-size: 12px;
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
            flex: 1;
            max-width: 80px;
        }

        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }

        .nav-item .icon-wrap {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 5px;
            transition: var(--transition);
            background: var(--card-bg);
        }

        .nav-item i {
            font-size: 18px;
        }

        .nav-item.active .icon-wrap {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }

        .nav-item.active span {
            color: var(--accent-gold);
            font-weight: 600;
        }

        @media (max-width: 480px) {
            main {
                padding: 15px;
            }
            
            .support-card {
                padding: 20px;
            }
            
            .support-header {
                flex-direction: column;
                text-align: center;
            }
            
            .support-icon {
                margin-right: 0;
                margin-bottom: 15px;
            }
            
            .nav-item {
                font-size: 11px;
                padding: 5px 8px;
            }
            
            .nav-item .icon-wrap {
                width: 36px;
                height: 36px;
            }
        }
    </style>
</head>

<body>
    <div class="navbar">
        <div class="left"><a href="{{ route('profile') }}"><i class="fas fa-arrow-left"></i> ফিরে যান</a></div>
        <div class="center"><i class="fas fa-headset me-2"></i>সাপোর্ট</div>
    </div>

    <main>
        <div class="support-container">
            <!-- Telegram Channel -->
            <div class="support-card">
                <div class="support-header">
                    <div class="support-icon">
                        <i class="fab fa-telegram"></i>
                    </div>
                    <div>
                        <div class="support-title">আমাদের টেলিগ্রাম চ্যানেল</div>
                        <div class="support-description">সর্বশেষ আপডেট এবং ঘোষণা পেতে আমাদের চ্যানেলে যোগ দিন</div>
                    </div>
                </div>
                <div class="contact-info">
                    <div class="contact-item">
                        <i class="fas fa-broadcast-tower"></i>
                        <span>চ্যানেল: @codekart_lab</span>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-bell"></i>
                        <span>নিয়মিত আপডেট এবং নোটিফিকেশন</span>
                    </div>
                </div>
                <button class="action-btn" onclick="window.open('https://t.me/codekart_lab', '_blank')">
                    <i class="fab fa-telegram me-2"></i>চ্যানেলে যোগ দিন
                </button>
            </div>

            <!-- Telegram Admin Support -->
            <div class="support-card">
                <div class="support-header">
                    <div class="support-icon">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <div>
                        <div class="support-title">টেলিগ্রাম অ্যাডমিন</div>
                        <div class="support-description">সরাসরি অ্যাডমিনের সাথে কথা বলুন এবং সাহায্য নিন</div>
                    </div>
                </div>
                <div class="contact-info">
                    <div class="contact-item">
                        <i class="fas fa-headset"></i>
                        <span>অ্যাডমিন: @codekart_lab</span>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-clock"></i>
                        <span>সময়: ২৪/৭ উপলব্ধ</span>
                    </div>
                </div>
                <button class="action-btn" onclick="window.open('https://t.me/codekart_lab', '_blank')">
                    <i class="fas fa-comment-dots me-2"></i>অ্যাডমিনের সাথে চ্যাট করুন
                </button>
            </div>

            <!-- Email Support -->
            <div class="support-card">
                <div class="support-header">
                    <div class="support-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div>
                        <div class="support-title">ইমেইল সাপোর্ট</div>
                        <div class="support-description">ইমেইলের মাধ্যমে আমাদের সাথে যোগাযোগ করুন</div>
                    </div>
                </div>
                <div class="contact-info">
                    <div class="contact-item">
                        <i class="fas fa-at"></i>
                        <span>support@codekartlab.site</span>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-reply"></i>
                        <span>প্রতিক্রিয়া সময়: ২৪ ঘন্টার মধ্যে</span>
                    </div>
                </div>
                <button class="action-btn" onclick="location.href='mailto:support@smartlab.com'">
                    <i class="fas fa-envelope me-2"></i>ইমেইল পাঠান
                </button>
            </div>

            <!-- FAQ Section -->
            <div class="faq-section">
                <h3 style="color: var(--accent-gold); margin-bottom: 20px; text-align: center;">
                    <i class="fas fa-question-circle me-2"></i>সচরাচর জিজ্ঞাসিত প্রশ্ন
                </h3>
                
                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFAQ(this)">
                        <span>অ্যাকাউন্ট কিভাবে তৈরি করব?</span>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        হোম পেজে গিয়ে রেজিস্ট্রেশন বাটনে ক্লিক করুন, প্রয়োজনীয় তথ্য দিয়ে ফর্ম পূরণ করুন এবং SMS ভেরিফিকেশন সম্পন্ন করুন।
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFAQ(this)">
                        <span>পাসওয়ার্ড ভুলে গেছি怎么办?</span>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        লগইন পেজে "পাসওয়ার্ড ভুলে গেছেন?" অপশনে ক্লিক করুন এবং আপনার রেজিস্টার্ড মোবাইল নম্বর দিয়ে পাসওয়ার্ড রিসেট করুন।
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFAQ(this)">
                        <span>উত্তোলন করতে কত সময় লাগে?</span>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        সাধারণত উত্তোলনের জন্য ২৪-৪৮ ঘন্টা সময় লাগে। ব্যাংকিং দিন এবং সাপ্তাহিক ছুটির দিন গণনা করা হয় না।
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFAQ(this)">
                        <span>কমিশন কিভাবে কাজ করে?</span>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        আপনি বন্ধুদের আমন্ত্রণ জানালে তাদের বিনিয়োগের উপর নির্দিষ্ট শতাংশ কমিশন পাবেন। কমিশন রেট বিভিন্ন লেভেলের জন্য ভিন্ন।
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFAQ(this)">
                        <span>টেলিগ্রামে কিভাবে যোগাযোগ করব?</span>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        উপরের "অ্যাডমিনের সাথে চ্যাট করুন" বাটনে ক্লিক করুন অথবা সরাসরি টেলিগ্রামে @codekart_lab এ মেসেজ পাঠান। আমরা ২৪/৭ সাহায্য করতে প্রস্তুত।
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="bottom-nav">
        <a href="{{ url('home') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-home"></i></div>
            <span>হোম</span>
        </a>
        <a href="{{ url('ordered') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-store"></i></div>
            <span>আমার খনন</span>
        </a>
        <a href="{{ url('my-team') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
            <span>আমন্ত্রণ</span>
        </a>
        <a href="{{ url('profile') }}" class="nav-item active">
            <div class="icon-wrap"><i class="fas fa-user"></i></div>
            <span>আমার</span>
        </a>
    </footer>

    <script>
        function toggleFAQ(element) {
            const faqItem = element.parentElement;
            faqItem.classList.toggle('active');
        }

        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.support-card');
            
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-5px)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });

            const buttons = document.querySelectorAll('.action-btn');
            buttons.forEach(btn => {
                btn.addEventListener('click', function() {
                    this.style.transform = 'scale(0.95)';
                    setTimeout(() => {
                        this.style.transform = '';
                    }, 150);
                });
            });
        });
    </script>
</body>
</html>