<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ env('APP_NAME') }}</title>

    
    <link rel="icon" href="/abir/abir1.png" type="image/png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }
       
        body {
            font-family: 'Montserrat', 'Noto Sans Bengali', sans-serif;
            background-color: var(--primary-bg);
            color: var(--text-primary);
            margin: 0;
            padding: 0;
        }
        
        main {
            max-width: 500px;
            margin: auto;
            padding-bottom: 100px;
            background: var(--primary-bg);
        }

        .plans-container {
            padding: 15px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--text-primary);
        }

        .navbar {
            background: linear-gradient(135deg, var(--secondary-bg), #2a2a2a);
            border-bottom: 2px solid var(--accent-gold);
            padding: 12px 0;
            width: 100%;
            font-size: 20px;
            font-weight: 700;
            color: var(--accent-gold);
            user-select: none;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 60px;
            position: sticky;
            top: 0;
            z-index: 1001;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
        }
        
        
        .ritem {
            background: var(--card-bg);
            box-shadow: var(--box-shadow);
            margin-bottom: 18px;
            color: var(--text-primary);
            padding: 18px 20px;
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
            overflow: hidden;
            transition: var(--transition);
            position: relative;
        }

        .ritem:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.2);
            border-color: var(--accent-gold);
        }

        .ritem_title {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            padding: 12px 15px;
            font-weight: 700;
            font-size: 18px;
            color: #000;
            margin: -20px -20px 15px -20px;
            border-radius: var(--border-radius) var(--border-radius) 0 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .ritem_title::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, transparent, rgba(0,0,0,0.3), transparent);
        }

        .ritem_box {
            padding-top: 6px;
        }

        .ritem_img {
            display: block;
            width: 80px;
            height: 80px;
            margin: 10px auto;
            border-radius: 12px;
            border: 2px solid var(--accent-gold);
            object-fit: cover;
            transition: var(--transition);
        }

        .ritem:hover .ritem_img {
            transform: scale(1.05);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.3);
        }

        .ritem_con {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            font-size: 15px;
            color: var(--text-secondary);
            border-bottom: 1px solid var(--border-color);
            transition: var(--transition);
        }

        .ritem_con:hover {
            color: var(--text-primary);
            background: rgba(255, 215, 0, 0.05);
            padding-left: 10px;
            padding-right: 10px;
            margin: 0 -10px;
            border-radius: 6px;
        }

        .ritem_con:last-child {
            border-bottom: none;
        }

        .jine {
            color: var(--accent-gold);
            font-weight: 700;
        }

        .ritem_footer {
            margin-top: 16px;
        }

        .profit-btn {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            padding: 12px;
            font-size: 16px;
            font-weight: bold;
            text-align: center;
            border: none;
            width: 100%;
            border-radius: 10px;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }

        .profit-btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.5);
        }
        
        .date-info {
            display: flex;
            justify-content: space-between;
            margin-top: 13px;
            width: 100%;
            font-size: 12px;
            color: var(--text-muted);
            background: rgba(255, 215, 0, 0.1);
            padding: 8px 12px;
            border-radius: 8px;
            border: 1px solid rgba(255, 215, 0, 0.2);
        }

        .empty-state {
            max-width: 380px;
            margin: 100px auto;
            padding: 30px 20px;
            text-align: center;
            background: var(--card-bg);
            color: var(--accent-gold);
            box-shadow: var(--box-shadow);
            font-size: 20px;
            font-weight: 600;
            user-select: none;
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
            transition: var(--transition);
        }

        .empty-state:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.2);
        }
        
        
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            display: flex;
            justify-content: space-around;
            background: var(--secondary-bg);
            border-top: 1px solid var(--border-color);
            padding: 12px 0;
            z-index: 1000;
            max-width: 500px;
            margin: 0 auto;
            right: 0;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
        }

        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: var(--text-muted);
            font-size: 12px;
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
            flex: 1;
            max-width: 80px;
        }

        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }

        .nav-item .icon-wrap {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 5px;
            transition: var(--transition);
            background: var(--card-bg);
        }

        .nav-item i {
            font-size: 18px;
        }

        .nav-item.active .icon-wrap {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }

        .nav-item.active span {
            color: var(--accent-gold);
            font-weight: 600;
        }

        /* Status badges */
        .status-badge {
            position: absolute;
            top: 10px;
            right: 10px;
            background: var(--accent-gold);
            color: #000;
            padding: 4px 8px;
            border-radius: 20px;
            font-size: 10px;
            font-weight: bold;
            z-index: 2;
        }

        /* Progress bar */
        .progress-container {
            margin-top: 10px;
            background: var(--border-color);
            border-radius: 10px;
            overflow: hidden;
            height: 6px;
        }

        .progress-bar {
            height: 100%;
            background: linear-gradient(90deg, var(--accent-gold), var(--accent-gold-light));
            border-radius: 10px;
            transition: width 0.5s ease;
        }

        /* Scrollbar styling */
        ::-webkit-scrollbar {
            width: 6px;
        }
        
        ::-webkit-scrollbar-track {
            background: var(--secondary-bg);
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--accent-gold);
            border-radius: 3px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: var(--accent-gold-light);
        }

        /* Responsive adjustments */
        @media (max-width: 480px) {
            .plans-container {
                padding: 10px;
            }
            
            .ritem {
                padding: 15px;
                margin-bottom: 15px;
            }
            
            .ritem_title {
                font-size: 16px;
                padding: 10px 12px;
                margin: -15px -15px 12px -15px;
            }
            
            .nav-item {
                font-size: 11px;
                padding: 5px 8px;
            }
            
            .nav-item .icon-wrap {
                width: 36px;
                height: 36px;
            }
        }
    </style>
</head>

<body>
    <main>
        <div class="navbar">আমার পরিকল্পনা</div>

        <div class="plans-container mt-4">

            @php
                $active_packages = \App\Models\Package::whereIn('id', my_active_vips())->get();
            @endphp

            @forelse($active_packages as $element)
                @php
                    $my = \App\Models\Purchase::where('user_id', user()->id)
                                             ->where('package_id', $element->id)
                                             ->where('status', 'active')
                                             ->first();
                @endphp

                <div class="ritem">
                    <div class="status-badge">ACTIVE</div>
                    <div class="ritem_title">{{ $element->name }}</div>
                    
                    <img class="ritem_img" src="{{ asset($element->photo) }}" alt="{{ $element->name }}">

                    <div class="ritem_box">
                        <div class="ritem_con">
                            <span>দৈনিক আয়</span>
                            <span class="jine">{{ price($element->commission_with_avg_amount / $element->validity) }}</span>
                        </div>
                        <div class="ritem_con">
                            <span>চক্র</span>
                            <span class="jine">{{ $element->validity }} দিন</span>
                        </div>
                        <div class="ritem_con">
                            <span>বিনিয়োগের পরিমাণ</span>
                            <span class="jine">{{ price($element->price) }}</span>
                        </div>
                        
                        <!-- Progress Bar -->
                        @if($my)
                        <div class="progress-container">
                            <div class="progress-bar" style="width: 75%"></div>
                        </div>
                        @endif
                    </div>
                    
                    <div class="ritem_footer">
                        <button type="button" class="profit-btn">
                            <i class="fas fa-coins me-2"></i>লাভ সংগ্রহ করুন
                        </button>
                        
                        @if($my)
                        <div class="date-info">
                            <div><i class="fas fa-calendar-plus me-1"></i>Registry: {{ \Carbon\Carbon::parse($my->created_at)->format('Y-m-d H:i') }}</div>
                            <div><i class="fas fa-calendar-times me-1"></i>Expire: {{ \Carbon\Carbon::parse($my->validity)->format('Y-m-d H:i') }}</div>
                        </div>
                        @endif
                    </div>
                </div>
            @empty
                <div class="empty-state">
                    <i class="fas fa-box-open mb-3" style="font-size: 48px; color: var(--accent-gold);"></i>
                    <br>
                    কোন পরিকল্পনা উপলব্ধ নেই
                </div>
            @endforelse

        </div>

    </main>

   <footer class="bottom-nav">
        <a href="{{ url('home') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-home"></i></div>
            <span>হোম</span>
        </a>
        <a href="{{ url('ordered') }}" class="nav-item active">
            <div class="icon-wrap"><i class="fas fa-store"></i></div>
            <span>আমার খনন</span>
        </a>
        <a href="{{ url('my-team') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
            <span> আমন্ত্রণ</span>
        </a>
        <a href="{{ url('profile') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-user"></i></div>
            <span>আমার</span>
        </a>
    </footer>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            // Add hover effects
            $('.ritem').hover(
                function() {
                    $(this).css('transform', 'translateY(-3px)');
                },
                function() {
                    $(this).css('transform', 'translateY(0)');
                }
            );

            // Profit button click effect
            $('.profit-btn').click(function() {
                const $btn = $(this);
                const originalText = $btn.html();
                
                $btn.html('<i class="fas fa-spinner fa-spin me-2"></i>প্রক্রিয়াকরণ...');
                $btn.prop('disabled', true);
                
                setTimeout(function() {
                    $btn.html('<i class="fas fa-check me-2"></i>লাভ সংগ্রহ করা হয়েছে');
                    $btn.css('background', 'linear-gradient(135deg, #28a745, #20c997)');
                    
                    setTimeout(function() {
                        $btn.html(originalText);
                        $btn.prop('disabled', false);
                        $btn.css('background', 'linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark))');
                    }, 2000);
                }, 1500);
            });

            // AJAX call for commission interest
            $.ajax({
                url: '{{ url('commission-interest') }}',
                type: 'GET',
                dataType: 'json',
                success: function(res) {
                    console.log('Commission interest calculated:', res);
                },
                error: function(err) {
                    console.error('Error calculating commission:', err);
                }
            });
        });
    </script>

</body>
</html>