@extends('app.layout.app')
@section('header_content')
    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        section.profile_photo {
            position: absolute;
            top: 90px;
            left: 50%;
            transform: translate(-50%, 0px);
        }
        .search-button {
            width: unset;
        }
        .navi-menu-button {
            width: unset;
        }
        header.no-background {
            background-color: var(--secondary-bg) !important;
        }
        footer {
            margin-bottom: 0px;
        }

        /* Improved Form Styles */
        main.margin {
            background: var(--primary-bg);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 500px;
            margin: 0 auto;
        }

        .form-row-group.with-icons {
            background: var(--card-bg);
            padding: 30px 25px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
        }

        .form-row {
            position: relative;
            margin-bottom: 20px;
            background: var(--secondary-bg);
            border-radius: 12px;
            border: 2px solid var(--border-color);
            transition: var(--transition);
        }

        .form-row:focus-within {
            border-color: var(--accent-gold);
            box-shadow: 0 0 0 3px rgba(255, 215, 0, 0.1);
            transform: translateY(-2px);
        }

        .form-row i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--accent-gold);
            font-size: 16px;
            z-index: 2;
        }

        .form-element {
            width: 100%;
            padding: 16px 16px 16px 50px;
            background: transparent;
            border: none;
            color: var(--text-primary);
            font-size: 15px;
            font-family: 'Noto Sans Bengali', sans-serif;
            border-radius: 12px;
        }

        .form-element:focus {
            outline: none;
        }

        .form-element::placeholder {
            color: var(--text-muted);
        }

        .btn {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            border: none;
            padding: 16px 30px;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
            display: inline-flex;
            align-items: center;
            gap: 8px;
            font-family: 'Noto Sans Bengali', sans-serif;
        }

        .btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 215, 0, 0.4);
        }

        .btn-dark {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
        }

        .text-center {
            text-align: center;
        }

        .mt-5 {
            margin-top: 30px;
        }

        .no-padding {
            padding: 0;
        }

        /* Mobile Responsive */
        @media (max-width: 480px) {
            .form-row-group.with-icons {
                padding: 25px 20px;
                margin: 10px;
            }

            .form-element {
                padding: 14px 14px 14px 45px;
                font-size: 14px;
            }

            .btn {
                padding: 14px 25px;
                font-size: 15px;
                width: 100%;
                justify-content: center;
            }

            .form-row i {
                font-size: 14px;
                left: 12px;
            }
        }

        @media (max-width: 360px) {
            .form-row-group.with-icons {
                padding: 20px 15px;
            }

            .form-element {
                padding: 12px 12px 12px 40px;
                font-size: 13px;
            }
        }
    </style>
@endsection

@section('app_content')
    <main class="margin">
        <section class="container">
            <div class="form-row-group with-icons">
                <form action="{{route('user.personal-details-submit')}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="form-row no-padding">
                        <i class="fa fa-user"></i>
                        <input type="text" name="name" class="form-element" placeholder="আপনার নাম" value="{{auth()->user()->name ?? old('name')}}">
                    </div>
                    <div class="form-row no-padding">
                        <i class="fa fa-user"></i>
                        <input type="text" name="username" class="form-element" placeholder="ব্যবহারকারীর নাম" value="{{auth()->user()->username}}">
                    </div>
                    <div class="form-row no-padding">
                        <i class="fa fa-envelope"></i>
                        <input type="email" name="email" class="form-element" placeholder="ইমেইল ঠিকানা" value="{{auth()->user()->email}}">
                    </div>
                    <div class="form-row no-padding">
                        <i class="fa fa-lock"></i>
                        <input type="password" name="password" class="form-element" placeholder="পাসওয়ার্ড" value="*********">
                    </div>
                    <div class="mt-5 text-center">
                        <button class="btn btn-dark">
                            <i class="fa fa-pencil"></i>
                            ব্যক্তিগত তথ্য আপডেট করুন
                        </button>
                    </div>
                </form>
            </div>
        </section>
        <footer>
        </footer>
    </main>
@endsection