<!doctype html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Spin & Earn - Coming Soon</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: var(--primary-bg);
            font-family: 'Noto Sans Bengali', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            color: var(--text-primary);
            text-align: center;
            padding: 20px;
            position: relative;
        }

        .coming-soon-container {
            background: var(--card-bg);
            padding: 60px 40px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            max-width: 400px;
            width: 100%;
        }

        .spin-icon {
            font-size: 80px;
            color: var(--accent-gold);
            margin-bottom: 30px;
            animation: spin 3s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        h1 {
            font-size: 32px;
            color: var(--accent-gold);
            margin-bottom: 15px;
            font-weight: 700;
        }

        .message {
            font-size: 18px;
            color: var(--text-secondary);
            margin-bottom: 30px;
            line-height: 1.5;
        }

        /* Single Fire Button at Bottom */
        .fire-button {
            position: fixed;
            bottom: 30px;
            left: 50%;
            transform: translateX(-50%);
            background: linear-gradient(135deg, #ff6b00, #ff0000);
            color: white;
            border: none;
            border-radius: 50px;
            padding: 15px 30px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 4px 20px rgba(255, 107, 0, 0.4);
            display: flex;
            align-items: center;
            gap: 10px;
            font-family: 'Noto Sans Bengali', sans-serif;
            z-index: 100;
            animation: firePulse 2s infinite;
        }

        .fire-button:hover {
            background: linear-gradient(135deg, #ff8c00, #ff4500);
            transform: translateX(-50%) translateY(-3px);
            box-shadow: 0 6px 25px rgba(255, 107, 0, 0.6);
        }

        .fire-icon {
            animation: fireFlicker 0.5s infinite alternate;
        }

        @keyframes firePulse {
            0% { box-shadow: 0 4px 20px rgba(255, 107, 0, 0.4); }
            50% { box-shadow: 0 4px 30px rgba(255, 107, 0, 0.7); }
            100% { box-shadow: 0 4px 20px rgba(255, 107, 0, 0.4); }
        }

        @keyframes fireFlicker {
            0% { transform: scale(1); }
            100% { transform: scale(1.2); }
        }

        @media (max-width: 480px) {
            .coming-soon-container {
                padding: 40px 25px;
            }

            .spin-icon {
                font-size: 60px;
            }

            h1 {
                font-size: 28px;
            }

            .message {
                font-size: 16px;
            }

            .fire-button {
                bottom: 20px;
                padding: 12px 25px;
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="coming-soon-container">
        <div class="spin-icon">
            <i class="fas fa-spinner"></i>
        </div>
        
        <h1>Spin & Earn</h1>
        <div class="message">শীঘ্রই আসছে</div>
    </div>

    <!-- Single Fire Button at Bottom -->
    <button class="fire-button" onclick="goToHome()">
        <i class="fas fa-fire fire-icon"></i>
        হোম পেজে যান
    </button>

    <script>
        function goToHome() {
            // Redirect to home page - change URL as needed
            window.location.href = '/home';
        }
    </script>
</body>
</html>