<!doctype html>
<html lang="bn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>BMF - Recharge</title>

    <!-- External Stylesheets -->
    <link rel="icon" href="/site/1176026229.jpg" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        body {
            background: var(--primary-bg);
            color: var(--text-primary);
            font-family: 'Montserrat', sans-serif;
            margin: 0;
            padding: 0;
        }
        main {
            max-width: 500px;
            margin: auto;
        }
        .views {
            max-width: 420px;
            margin: 0 auto;
            padding: 70px 15px 100px;
        }
        .navbar {
            position: fixed; 
            top: 0; 
            left: 0; 
            right: 0; 
            max-width: 500px; 
            margin: auto;
            width: 100%; 
            height: 60px; 
            background: var(--secondary-bg);
            display: flex; 
            align-items: center; 
            justify-content: center;
            color: var(--accent-gold); 
            font-weight: 700; 
            font-size: 20px;
            z-index: 1100; 
            border-bottom: 1px solid var(--border-color);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
        }
        .navbar .left { 
            position: absolute; 
            left: 15px; 
            top: 50%; 
            transform: translateY(-50%); 
        }
        .navbar .left a { 
            color: var(--accent-gold); 
            font-size: 22px; 
            text-decoration: none; 
            display: flex; 
            align-items: center; 
            padding: 8px 12px;
            border-radius: 8px;
            transition: var(--transition);
        }
        .navbar .left a:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: translateY(-50%) scale(1.05);
        }
        .balance-section {
            background: var(--card-bg);
            text-align: center; 
            padding: 25px 0; 
            margin-bottom: 25px; 
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            position: relative;
            transition: var(--transition);
        }
        .balance-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }
        .balance-section:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.2);
        }
        .balance-section p:first-child { 
            font-size: 14px; 
            color: var(--text-secondary); 
            letter-spacing: 1px; 
            margin-bottom: 8px; 
            text-transform: uppercase; 
        }
        .balance-section p:last-child { 
            font-size: 32px; 
            font-weight: 800; 
            color: var(--accent-gold); 
            margin-top: 0; 
        }
        .content-wrapper { 
            background: var(--card-bg); 
            padding: 25px 20px; 
            border-radius: var(--border-radius); 
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            position: relative;
        }
        .content-wrapper::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }
        input[type=number] { 
            width: 100%; 
            background: var(--secondary-bg); 
            border: 1px solid var(--border-color); 
            padding: 15px 18px; 
            font-size: 17px; 
            color: var(--text-primary); 
            font-weight: 700; 
            margin-bottom: 25px; 
            border-radius: 10px; 
            box-sizing: border-box;
            transition: var(--transition);
        }
        input[type=number]:focus {
            outline: none;
            border-color: var(--accent-gold);
            box-shadow: 0 0 0 2px rgba(255, 215, 0, 0.2);
        }
        .recharge-price-list ul { 
            display: flex; 
            flex-wrap: wrap; 
            gap: 12px; 
            padding: 0; 
            list-style: none; 
            justify-content: center; 
            margin-bottom: 25px; 
        }
        .recharge-price-list ul li { 
            flex: 1 1 30%; 
            background: var(--secondary-bg); 
            color: var(--text-secondary); 
            font-weight: 600; 
            font-size: 14px; 
            text-align: center; 
            padding: 12px 0; 
            cursor: pointer; 
            box-shadow: var(--box-shadow); 
            border-radius: 10px; 
            border: 1px solid var(--border-color);
            transition: var(--transition);
        }
        .recharge-price-list ul li:hover {
            background: rgba(255, 215, 0, 0.1);
            color: var(--text-primary);
            border-color: var(--accent-gold);
        }
        .recharge-price-list ul li.cur { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            border: 1px solid var(--accent-gold);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }
        .Putforwardbtn button { 
            width: 100%; 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            border: none; 
            padding: 16px 0; 
            font-size: 16px; 
            font-weight: 800; 
            color: #000; 
            cursor: pointer; 
            border-radius: 12px;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }
        .Putforwardbtn button:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.5);
        }
        .Putforwardbox { 
            background: var(--secondary-bg); 
            padding: 20px; 
            color: var(--text-secondary); 
            font-size: 14px; 
            line-height: 1.6; 
            margin-bottom: 25px; 
            border-left: 4px solid var(--accent-gold); 
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
            transition: var(--transition);
        }
        .Putforwardbox:hover {
            border-color: var(--accent-gold);
            transform: translateY(-2px);
        }
        .bottom-nav { 
            position: fixed; 
            bottom: 0; 
            left: 0; 
            right: 0; 
            max-width: 500px; 
            margin: auto; 
            width: 100%; 
            display: flex; 
            justify-content: space-around; 
            background: var(--secondary-bg); 
            border-top: 1px solid var(--border-color); 
            padding: 12px 0; 
            z-index: 1000; 
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
        }
        .nav-item { 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            text-decoration: none; 
            color: var(--text-muted); 
            font-size: 12px; 
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
            flex: 1;
            max-width: 80px;
        }
        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }
        .nav-item .icon-wrap { 
            width: 40px; 
            height: 40px; 
            border-radius: 10px; 
            display: flex; 
            justify-content: center; 
            align-items: center; 
            margin-bottom: 5px; 
            transition: var(--transition);
            background: var(--card-bg);
        }
        .nav-item i { 
            font-size: 18px; 
        }
        .nav-item.active .icon-wrap { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }
        .nav-item.active span { 
            color: var(--accent-gold); 
            font-weight: 600;
        }

        @media (max-width: 480px) {
            .views {
                padding: 70px 10px 100px;
            }
            
            .balance-section {
                padding: 20px 0;
            }
            
            .balance-section p:last-child {
                font-size: 28px;
            }
            
            .content-wrapper {
                padding: 20px 15px;
            }
            
            .recharge-price-list ul li {
                flex: 1 1 45%;
                font-size: 13px;
                padding: 10px 0;
            }
            
            .nav-item {
                font-size: 11px;
                padding: 5px 8px;
            }
            
            .nav-item .icon-wrap {
                width: 36px;
                height: 36px;
            }
        }
    </style>
</head>

<body>
    <main>
        <div class="navbar">
            <div class="left"><a href="{{ url()->previous() }}"><i class="fas fa-arrow-left"></i></a></div>
            <i class="fas fa-wallet me-2"></i>Recharge
        </div>
        
        <div class="views">
            <div class="balance-section">
                <p>Account Balance</p>
                <p>{{ price(user()->balance) }}</p>
            </div>
            
            <div class="Putforwardbox">
                <p><i class="fas fa-info-circle me-2"></i>Recharge instructions: Please follow the correct payment process. After payment is complete, submit the TRX number and the funds will be automatically credited to the account balance.</p>
            </div>
            
            <div class="content-wrapper">
                <input type="number" min="300" required name="amount" placeholder="জমা পরিমাণ লিখুন" />

                <div class="recharge-price-list">
                    <ul>
                        <li onclick="changeValue(this, 300)">Tk 300</li>
                        <li onclick="changeValue(this, 600)">Tk 600</li>
                        <li onclick="changeValue(this, 1500)">Tk 1500</li>
                        <li onclick="changeValue(this, 4000)">Tk 4000</li>
                        <li onclick="changeValue(this, 10000)">Tk 10000</li>
                        <li onclick="changeValue(this, 25000)">Tk 25000</li>
                    </ul>
                </div>

                <div class="Putforwardbtn">
                    <button type="button" onclick="payment()">
                        <i class="fas fa-arrow-right me-2"></i>Go Ahead
                    </button>
                </div>
            </div>
        </div>
    </main>

    <footer class="bottom-nav">
        <a href="{{ url('home') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-home"></i></div>
            <span>হোম</span>
        </a>
        <a href="{{ url('ordered') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-store"></i></div>
            <span>খনন</span>
        </a>
        <a href="{{ url('my-team') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
            <span>আমন্ত্রণ</span>
        </a>
        <a href="{{ url('profile') }}" class="nav-item active">
            <div class="icon-wrap"><i class="fas fa-user"></i></div>
            <span>আমার</span>
        </a>
    </footer>

    <script>
        function changeValue(element, value) {
            document.querySelector('input[name="amount"]').value = value;
            document.querySelectorAll('.recharge-price-list ul li').forEach(li => li.classList.remove('cur'));
            element.classList.add('cur');
        }

        function payment() {
            var amount = document.querySelector('input[name="amount"]').value;
            if (amount && parseInt(amount) >= 300) {
                // loading(); // আপনার যদি loading() ফাংশন থাকে, তবে এটি আনকমেন্ট করুন
                
                // এই URL টি আপনার মূল কোডের কার্যকারিতার সাথে হুবহু মিলানো হয়েছে
                window.location.href = '{{ url("user/payment/") }}' + '/' + amount;
            } else {
                // notice('Enter your amount'); // আপনার যদি notice() ফাংশন থাকে
                alert('Please enter an amount of 300 or more.');
            }
        }

        // Add interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.balance-section, .content-wrapper, .Putforwardbox');
            
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-3px)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });

            const buttons = document.querySelectorAll('.Putforwardbtn button');
            buttons.forEach(btn => {
                btn.addEventListener('click', function() {
                    this.style.transform = 'scale(0.95)';
                    setTimeout(() => {
                        this.style.transform = '';
                    }, 150);
                });
            });

            const priceItems = document.querySelectorAll('.recharge-price-list ul li');
            priceItems.forEach(item => {
                item.addEventListener('click', function() {
                    this.style.transform = 'scale(0.95)';
                    setTimeout(() => {
                        this.style.transform = '';
                    }, 150);
                });
            });
        });
    </script>
</body>
</html>