<!DOCTYPE html>
<html lang="bn" data-dpr="1" style="font-size: 38.1px;">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{env('APP_NAME')}} - Add Wallet</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        * { 
            margin: 0; 
            padding: 0; 
            box-sizing: border-box; 
        }
        
        body { 
            font-family: 'Noto Sans Bengali', sans-serif; 
            background: var(--primary-bg); 
            color: var(--text-primary);
            font-size: 12px;
            padding-bottom: 1.33333rem;
        }
        
        .basic_wrap {
            max-width: 500px;
            margin: 0 auto;
            background: var(--primary-bg);
        }
        
        .red_top_bg {
            display: flex;
            align-items: center;
            padding: 15px 20px;
            background: var(--secondary-bg);
            border-bottom: 1px solid var(--border-color);
            position: relative;
        }
        
        .back_left {
            width: 30px;
            height: 30px;
            background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='%23ffd700'%3E%3Cpath d='M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z'/%3E%3C/svg%3E") no-repeat center;
            background-size: contain;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .back_left:hover {
            transform: translateX(-3px);
        }
        
        .big_tit {
            flex: 1;
            text-align: center;
            font-size: 18px;
            font-weight: 700;
            color: var(--accent-gold);
        }
        
        .wrap {
            padding: 20px;
        }
        
        .title {
            text-align: center;
            margin-bottom: 25px;
        }
        
        .title p {
            font-size: 20px;
            font-weight: 600;
            color: var(--text-primary);
            margin: 0;
        }
        
        .bd_tel {
            text-align: center;
            color: var(--text-secondary);
            margin-bottom: 20px;
            padding: 12px;
            background: var(--secondary-bg);
            border-radius: 10px;
            border: 1px solid var(--border-color);
            font-size: 14px;
        }
        
        .write_box {
            margin-bottom: 20px;
            position: relative;
        }
        
        .write_box input, 
        .write_box select {
            width: 100%;
            padding: 16px 15px;
            background: var(--card-bg);
            border: 2px solid var(--border-color);
            border-radius: 12px;
            color: var(--text-primary);
            font-size: 16px;
            font-family: 'Noto Sans Bengali', sans-serif;
            transition: var(--transition);
        }
        
        .write_box input:focus, 
        .write_box select:focus {
            outline: none;
            border-color: var(--accent-gold);
            box-shadow: 0 0 0 3px rgba(255, 215, 0, 0.1);
        }
        
        .write_box input::placeholder {
            color: var(--text-muted);
        }
        
        select#gateway_method {
            width: 100%;
            font-size: 16px;
            color: var(--text-primary);
            background: var(--card-bg);
            cursor: pointer;
        }
        
        select#gateway_method option {
            background: var(--card-bg);
            color: var(--text-primary);
            padding: 10px;
        }
        
        .write_new_pwd {
            margin-top: 10px;
        }
        
        .basic_btn {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            text-align: center;
            padding: 18px;
            margin: 30px 20px 20px;
            border-radius: 12px;
            font-weight: 700;
            font-size: 16px;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
            border: none;
        }
        
        .basic_btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 215, 0, 0.4);
        }
        
        .basic_btn:active {
            transform: translateY(0);
        }
        
        /* Alert Message Styling */
        .alert-message {
            padding: 15px 20px;
            margin: 10px 20px;
            border-radius: 10px;
            font-weight: 600;
            text-align: center;
            border: 1px solid transparent;
        }
        
        .alert-success {
            background: rgba(76, 175, 80, 0.1);
            color: #4CAF50;
            border-color: #4CAF50;
        }
        
        .alert-error {
            background: rgba(244, 67, 54, 0.1);
            color: #f44336;
            border-color: #f44336;
        }
        
        .alert-warning {
            background: rgba(255, 193, 7, 0.1);
            color: var(--accent-gold);
            border-color: var(--accent-gold);
        }
        
        @media (max-width: 480px) {
            .wrap {
                padding: 15px;
            }
            
            .title p {
                font-size: 18px;
            }
            
            .big_tit {
                font-size: 16px;
            }
            
            .write_box input, 
            .write_box select {
                padding: 14px 12px;
                font-size: 14px;
            }
            
            .basic_btn {
                margin: 25px 15px 15px;
                padding: 16px;
                font-size: 15px;
            }
        }
        
        /* Loading state */
        .loading {
            opacity: 0.7;
            pointer-events: none;
        }
        
        .form-group {
            position: relative;
        }
        
        .form-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--accent-gold);
            z-index: 1;
        }
        
        .form-group input, 
        .form-group select {
            padding-left: 45px !important;
        }
    </style>
</head>
<body>
<div id="app">
    @include('alert-message')
    <form action="{{route('setup.gateway.submit')}}" method="post"> 
        @csrf
        <div class="basic_wrap">
            <div class="red_top_bg">
                <div class="back_left" onclick="window.location.href='{{route('user.bank.create')}}'"></div>
                <div class="big_tit"><i class="fas fa-wallet me-2"></i>ফাইন্যান্স ওয়ালেট</div>
            </div>
            <div class="wrap">
                <div class="title">
                    <p>ওয়ালেট পরিবর্তন বা তৈরি করুন</p>
                </div>
                
                @if(user()->gateway_number)
                <p class="bd_tel">
                    <i class="fas fa-info-circle me-2"></i>
                    সংযুক্ত অ্যাকাউন্ট নম্বর: {{user()->gateway_number}}
                </p>
                @endif
                
                <div class="form-group">
                    <div class="write_box">
                        <i class="fas fa-user"></i>
                        <input placeholder="আপনার আসল নাম লিখুন" type="text" name="name" value="{{ old('name') }}" required>
                    </div>
                </div>
                
                <div class="write_new_pwd">
                    <div class="form-group">
                        <div class="write_box">
                            <i class="fas fa-credit-card"></i>
                            <select name="gateway_method" id="gateway_method" required>
                                <option value="">পেমেন্ট মেথড নির্বাচন করুন</option>
                                @foreach(\App\Models\PaymentMethod::get() as $element)
                                <option value="{{$element->name}}" {{ old('gateway_method') == $element->name ? 'selected' : '' }}>
                                    {{$element->name}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="write_box">
                            <i class="fas fa-university"></i>
                            <input placeholder="আপনার ব্যাংক অ্যাকাউন্ট নম্বর লিখুন" type="text" name="gateway_number" value="{{ old('gateway_number') }}" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <button type="button" class="basic_btn" onclick="bank()">
            <i class="fas fa-save me-2"></i>পরিবর্তন করুন
        </button>
    </form>
</div>

<script>
    function bank() {
        // Show loading state
        const btn = document.querySelector('.basic_btn');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>প্রসেসিং...';
        btn.classList.add('loading');
        
        // Validate form
        const form = document.querySelector('form');
        const name = form.querySelector('input[name="name"]').value;
        const method = form.querySelector('select[name="gateway_method"]').value;
        const number = form.querySelector('input[name="gateway_number"]').value;
        
        if (!name || !method || !number) {
            alert('দয়া করে সমস্ত তথ্য পূরণ করুন');
            btn.innerHTML = originalText;
            btn.classList.remove('loading');
            return;
        }
        
        // Submit form
        form.submit();
    }
    
    // Add input focus effects
    document.addEventListener('DOMContentLoaded', function() {
        const inputs = document.querySelectorAll('input, select');
        
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.transform = 'translateY(-2px)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.style.transform = 'translateY(0)';
            });
        });
        
        // Add button click effect
        const btn = document.querySelector('.basic_btn');
        btn.addEventListener('mousedown', function() {
            this.style.transform = 'scale(0.98)';
        });
        
        btn.addEventListener('mouseup', function() {
            this.style.transform = '';
        });
    });
</script>
</body>
</html>