<!doctype html>
<html lang="bn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, viewport-fit=cover">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{env('APP_NAME')}} - Wallet</title>

    <link rel="icon" href="/CodeKartLab/main-logo.png" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        * { 
            margin: 0; 
            padding: 0; 
            box-sizing: border-box; 
        }
        
        body { 
            font-family: 'Noto Sans Bengali', sans-serif; 
            background: var(--primary-bg); 
            color: var(--text-primary); 
        }
        
        #app-container { 
            display: flex; 
            flex-direction: column; 
            min-height: 100vh; 
        }
        
        .header-fixed { 
            position: fixed; 
            top: 0; 
            width: 100%; 
            max-width: 500px; 
            z-index: 100; 
        }
        
        main { 
            flex: 1; 
            overflow-y: auto; 
            padding-top: 70px; 
            padding-bottom: 80px; 
            background: var(--primary-bg); 
        }
        
        .footer-fixed { 
            position: fixed; 
            bottom: 0; 
            width: 100%; 
            max-width: 500px; 
            z-index: 100; 
        }
        
        .header { 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
            padding: 12px 20px; 
            background: var(--secondary-bg); 
            border-bottom: 1px solid var(--border-color);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
        }
        
        .header .left { 
            display: flex; 
            align-items: center; 
            gap: 12px; 
        }
        
        .header .left img { 
            width: 42px; 
            height: 42px; 
            border-radius: 50%; 
            border: 2px solid var(--accent-gold);
        }
        
        .header .left span { 
            color: var(--text-primary); 
            font-weight: bold; 
            font-size: 16px;
        }
        
        .lang-btn { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            border: none; 
            padding: 6px 14px; 
            font-weight: bold; 
            border-radius: 20px; 
            font-size: 14px; 
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }

        .lang-btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.4);
        }
        
        .bottom-nav { 
            display: flex; 
            justify-content: space-around; 
            background: var(--secondary-bg); 
            border-top: 1px solid var(--border-color); 
            padding: 12px 0; 
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
        }
        
        .nav-item { 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            text-decoration: none; 
            color: var(--text-muted); 
            font-size: 12px; 
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
            flex: 1;
            max-width: 80px;
        }

        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }
        
        .nav-item .icon-wrap { 
            width: 40px; 
            height: 40px; 
            border-radius: 10px; 
            display: flex; 
            justify-content: center; 
            align-items: center; 
            margin-bottom: 5px; 
            transition: var(--transition);
            background: var(--card-bg);
        }
        
        .nav-item i { 
            font-size: 18px; 
        }
        
        .nav-item.active .icon-wrap { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }
        
        .nav-item.active span { 
            color: var(--accent-gold); 
            font-weight: 600;
        }

        /* Custom Styles for Wallet Management Content */
        .page-title {
            text-align: center;
            font-size: 24px;
            font-weight: 700;
            margin: 25px 15px;
            color: var(--accent-gold);
        }

        .wallet-card {
            background: var(--card-bg);
            margin: 20px 15px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            padding: 25px;
            text-align: center;
            border: 1px solid var(--border-color);
            position: relative;
            transition: var(--transition);
        }

        .wallet-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .wallet-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(255, 215, 0, 0.2);
            border-color: var(--accent-gold);
        }

        .wallet-card .status-text {
            font-size: 1.1rem;
            color: var(--text-secondary);
            font-weight: 600;
            margin-bottom: 15px;
        }

        .wallet-card .status-text .count {
            font-size: 3rem;
            font-weight: 700;
            color: var(--accent-gold);
            display: block;
            margin-bottom: 15px;
            text-shadow: 0 2px 4px rgba(255, 215, 0, 0.3);
        }

        .wallet-icon {
            font-size: 48px;
            color: var(--accent-gold);
            margin-bottom: 20px;
            transition: var(--transition);
        }

        .wallet-card:hover .wallet-icon {
            transform: scale(1.1);
        }

        .wallet-button-container {
            padding: 20px 15px;
        }

        .wallet-btn {
            display: block;
            width: 100%;
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            padding: 16px;
            font-size: 16px;
            font-weight: bold;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            text-decoration: none;
            color: #000;
            text-align: center;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }

        .wallet-btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.5);
        }

        .wallet-info {
            background: var(--secondary-bg);
            margin: 20px 15px;
            border-radius: var(--border-radius);
            padding: 20px;
            border: 1px solid var(--border-color);
            box-shadow: var(--box-shadow);
        }

        .wallet-info h3 {
            color: var(--accent-gold);
            margin-bottom: 15px;
            font-size: 18px;
            text-align: center;
        }

        .wallet-info p {
            color: var(--text-secondary);
            font-size: 14px;
            line-height: 1.6;
            text-align: center;
        }

        @media (max-width: 480px) {
            main {
                padding-top: 70px;
                padding-bottom: 80px;
            }
            
            .page-title {
                font-size: 22px;
                margin: 20px 15px;
            }
            
            .wallet-card {
                margin: 15px 10px;
                padding: 20px;
            }
            
            .wallet-card .status-text .count {
                font-size: 2.5rem;
            }
            
            .wallet-icon {
                font-size: 40px;
            }
            
            .nav-item {
                font-size: 11px;
                padding: 5px 8px;
            }
            
            .nav-item .icon-wrap {
                width: 36px;
                height: 36px;
            }
        }
    </style>
</head>
<body>

<div id="app-container">
    
    <div class="header-fixed">
        <div class="header">
            <div class="left">
                <img src="/CodeKartLab/main-logo.png" alt="logo">
                <span>{{ auth()->user()->name ?? 'ব্যবহারকারী' }}</span>
            </div>
            <button class="lang-btn">বাংলা</button>
        </div>
    </div>

    <main>
    
        <h2 class="page-title"><i class="fas fa-wallet me-2"></i>ওয়ালেট ম্যানেজমেন্ট</h2>

        <!-- Wallet Information Display -->
        <div class="wallet-card">
            <div class="wallet-icon">
                <i class="fas fa-credit-card"></i>
            </div>
            <p class="status-text">
                <span class="count">
                    @if(user()->gateway_method == null || user()->gateway_number == null) 0 @else 1 @endif
                </span>
                সংযুক্ত ওয়ালেট
            </p>
        </div>

        <!-- Wallet Information -->
        <div class="wallet-info">
            <h3><i class="fas fa-info-circle me-2"></i>ওয়ালেট তথ্য</h3>
            <p>আপনার ওয়ালেট সফলভাবে সংযুক্ত করুন উত্তোলনের জন্য। একটি ওয়ালেট সংযুক্ত থাকলে উত্তোলন প্রক্রিয়া সহজ হবে।</p>
        </div>
        
        <!-- Button to go to the wallet creation page -->
        <div class="wallet-button-container">
            <a href="{{ route('make.wallet') }}" class="wallet-btn">
                <i class="fas fa-plus-circle me-2"></i>Add Wallet
            </a>
        </div>
      
    </main>

    <div class="footer-fixed">
        <footer class="bottom-nav">
            <a href="{{ url('home') }}" class="nav-item">
                <div class="icon-wrap"><i class="fas fa-home"></i></div>
                <span>হোম</span>
            </a>
            <a href="{{ url('ordered') }}" class="nav-item">
                <div class="icon-wrap"><i class="fas fa-store"></i></div>
                <span>খনন</span>
            </a>
            <a href="{{ url('my-team') }}" class="nav-item">
                <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
                <span>আমন্ত্রণ</span>
            </a>
            <a href="{{ url('profile') }}" class="nav-item active">
                <div class="icon-wrap"><i class="fas fa-user"></i></div>
                <span>আমার</span>
            </a>
        </footer>
    </div>

</div>

<script>
    // Add interactive effects
    document.addEventListener('DOMContentLoaded', function() {
        const cards = document.querySelectorAll('.wallet-card');
        
        cards.forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-5px)';
            });
            
            card.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });

        const buttons = document.querySelectorAll('.wallet-btn, .lang-btn');
        buttons.forEach(btn => {
            btn.addEventListener('click', function() {
                this.style.transform = 'scale(0.95)';
                setTimeout(() => {
                    this.style.transform = '';
                }, 150);
            });
        });

        const navItems = document.querySelectorAll('.nav-item');
        navItems.forEach(item => {
            item.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-2px)';
            });
            
            item.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });
    });
</script>
</body>
</html>