@extends('admin.partials.master')
@section('admin_content')
    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        .card {
            background: var(--card-bg) !important;
            border: 1px solid var(--border-color) !important;
            border-radius: var(--border-radius) !important;
            box-shadow: var(--box-shadow) !important;
            transition: var(--transition) !important;
        }

        .card:hover {
            transform: translateY(-5px) !important;
            box-shadow: 0 8px 25px rgba(255, 215, 0, 0.15) !important;
            border-color: var(--accent-gold) !important;
        }

        .card-body {
            background: var(--card-bg) !important;
            padding: 2rem 1rem !important;
        }

        .text-muted {
            color: var(--text-secondary) !important;
            font-size: 14px !important;
            font-weight: 600 !important;
            margin-bottom: 10px !important;
        }

        h3 {
            color: var(--accent-gold) !important;
            font-size: 28px !important;
            font-weight: 700 !important;
            margin-bottom: 0 !important;
            text-shadow: 0 2px 4px rgba(255, 215, 0, 0.3) !important;
        }

        .badge-circle {
            width: 70px !important;
            height: 70px !important;
            border-radius: 50% !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            margin-bottom: 1rem !important;
            transition: var(--transition) !important;
        }

        .badge-circle-light-danger {
            background: rgba(255, 215, 0, 0.1) !important;
            border: 2px solid var(--accent-gold) !important;
        }

        .badge-circle-light-success {
            background: rgba(255, 215, 0, 0.1) !important;
            border: 2px solid var(--accent-gold) !important;
        }

        .badge-circle i {
            color: var(--accent-gold) !important;
            font-size: 24px !important;
        }

        .badge-circle:hover {
            transform: scale(1.1) !important;
            background: rgba(255, 215, 0, 0.2) !important;
        }

        .card-content {
            position: relative !important;
        }

        .card-content::before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            height: 3px !important;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark)) !important;
            border-radius: var(--border-radius) var(--border-radius) 0 0 !important;
        }

        .py-1 {
            padding-top: 1.5rem !important;
            padding-bottom: 1.5rem !important;
        }

        .mb-50 {
            margin-bottom: 1.5rem !important;
        }

        .mb-0 {
            margin-bottom: 0 !important;
        }

        .line-ellipsis {
            white-space: nowrap !important;
            overflow: hidden !important;
            text-overflow: ellipsis !important;
        }

        #dashboard-ecommerce {
            background: var(--primary-bg) !important;
            padding: 20px !important;
            min-height: 100vh !important;
        }

        .dashboard-users {
            margin-bottom: 2rem !important;
        }

        .row {
            margin-right: -10px !important;
            margin-left: -10px !important;
        }

        .col-sm-4, .col-12 {
            padding-right: 10px !important;
            padding-left: 10px !important;
            margin-bottom: 20px !important;
        }

        .text-center {
            text-align: center !important;
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .col-sm-4 {
                flex: 0 0 100% !important;
                max-width: 100% !important;
            }
            
            .card-body {
                padding: 1.5rem 1rem !important;
            }
            
            h3 {
                font-size: 24px !important;
            }
            
            .badge-circle {
                width: 60px !important;
                height: 60px !important;
            }
            
            .badge-circle i {
                font-size: 20px !important;
            }
        }

        @media (max-width: 576px) {
            #dashboard-ecommerce {
                padding: 15px !important;
            }
            
            .card-body {
                padding: 1rem 0.5rem !important;
            }
            
            h3 {
                font-size: 22px !important;
            }
            
            .text-muted {
                font-size: 13px !important;
            }
        }
    </style>
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-xl-12 col-12 dashboard-users">
                <div class="row">
                    <div class="col-12">
                        <div class="row">
                            <!-- Users Card -->
                            <div class="col-sm-4 col-12 dashboard-users-danger">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                                <i class="bx bx-user font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">মোট ব্যবহারকারী</div>
                                            <h3 class="mb-0">{{\App\Models\User::get()->count()}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Total Purchase Card -->
                            <div class="col-sm-4 col-12 dashboard-users-success">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div class="badge-circle badge-circle-lg badge-circle-light-success mx-auto mb-50">
                                                <i class="bx bx-briefcase-alt font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">মোট ক্রয়</div>
                                            <h3 class="mb-0">{{\App\Models\Purchase::get()->count()}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Total Checkin Card -->
                            <div class="col-sm-4 col-12 dashboard-users-success">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div class="badge-circle badge-circle-lg badge-circle-light-success mx-auto mb-50">
                                                <i class="bx bx-briefcase-alt font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">মোট চেক-ইন</div>
                                            <h3 class="mb-0">{{\App\Models\Checkin::get()->count()}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Approved Withdraw Card -->
                            <div class="col-sm-4 col-12 dashboard-users-danger">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                                <i class="bx bx-circle font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">অনুমোদিত উত্তোলন</div>
                                            <h3 class="mb-0">{{price(\App\Models\Withdrawal::where('status', 'approved')->get()->sum('amount'))}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Pending Withdraw Card -->
                            <div class="col-sm-4 col-12 dashboard-users-danger">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                                <i class="bx bx-circle font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">বিচারাধীন উত্তোলন</div>
                                            <h3 class="mb-0">{{price(\App\Models\Withdrawal::where('status', 'pending')->get()->sum('amount'))}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Rejected Withdraw Card -->
                            <div class="col-sm-4 col-12 dashboard-users-danger">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                                <i class="bx bx-circle font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">বাতিল উত্তোলন</div>
                                            <h3 class="mb-0">{{price(\App\Models\Withdrawal::where('status', 'rejected')->get()->sum('amount'))}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Approved Deposit Card -->
                            <div class="col-sm-4 col-12 dashboard-users-danger">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                                <i class="bx bx-circle font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">অনুমোদিত ডিপোজিট</div>
                                            <h3 class="mb-0">{{price(\App\Models\Deposit::where('status', 'approved')->get()->sum('amount'))}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Pending Deposit Card -->
                            <div class="col-sm-4 col-12 dashboard-users-danger">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                                <i class="bx bx-circle font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">বিচারাধীন ডিপোজিট</div>
                                            <h3 class="mb-0">{{price(\App\Models\Deposit::where('status', 'pending')->get()->sum('amount'))}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Rejected Deposit Card -->
                            <div class="col-sm-4 col-12 dashboard-users-danger">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                                <i class="bx bx-circle font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">বাতিল ডিপোজিট</div>
                                            <h3 class="mb-0">{{price(\App\Models\Deposit::where('status', 'rejected')->get()->sum('amount'))}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection