<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\Purchase;
use App\Models\Rebate;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\Withdrawal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TeamController extends Controller
{
   
    public function team()
    {
        $user = Auth::user();

       
        
        $first_level_users = User::where('ref_by', $user->ref_id)->get();
        $first_ids = $first_level_users->pluck('id');

        $first_level_ref_ids = $first_level_users->pluck('ref_id')->filter();
        $second_level_users = $first_level_ref_ids->isNotEmpty() ? User::whereIn('ref_by', $first_level_ref_ids)->get() : collect();
        $second_ids = $second_level_users->pluck('id');

        $second_level_ref_ids = $second_level_users->pluck('ref_id')->filter();
        $third_level_users = $second_level_ref_ids->isNotEmpty() ? User::whereIn('ref_by', $second_level_ref_ids)->get() : collect();
        $third_ids = $third_level_users->pluck('id');
        
      
        $team_size = $first_level_users->count() + $second_level_users->count() + $third_level_users->count();
        $rebate = Rebate::first();

        $lv1Recharge = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
        $lv2Recharge = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
        $lv3Recharge = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');
        $lvTotalDeposit = $lv1Recharge + $lv2Recharge + $lv3Recharge;

        $lv1Withdraw = Withdrawal::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
        $lv2Withdraw = Withdrawal::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
        $lv3Withdraw = Withdrawal::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');
        $lvTotalWithdraw = $lv1Withdraw + $lv2Withdraw + $lv3Withdraw;

        $activeMembers1 = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->distinct('user_id')->count('user_id');
        $activeMembers2 = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->distinct('user_id')->count('user_id');
        $activeMembers3 = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->distinct('user_id')->count('user_id');

        $totalLevelInvest1 = Purchase::whereIn('user_id', $first_ids)->sum('amount');
        $totalLevelInvest2 = Purchase::whereIn('user_id', $second_ids)->sum('amount');
        $totalLevelInvest3 = Purchase::whereIn('user_id', $third_ids)->sum('amount');
        $totalInvestment = $totalLevelInvest1 + $totalLevelInvest2 + $totalLevelInvest3;

        $levelTotalCommission1 = UserLedger::where('user_id', auth()->id())->where('reason', 'commission')->where('step', 'first')->sum('amount');
        $levelTotalCommission2 = UserLedger::where('user_id', auth()->id())->where('reason', 'commission')->where('step', 'second')->sum('amount');
        $levelTotalCommission3 = UserLedger::where('user_id', auth()->id())->where('reason', 'commission')->where('step', 'third')->sum('amount');

        
        return view('app.main.team.index', compact(
            'first_level_users', 'second_level_users', 'third_level_users', 'rebate', 'team_size',
            'lvTotalDeposit', 'lvTotalWithdraw', 'lv1Recharge', 'lv2Recharge', 'lv3Recharge',
            'lv1Withdraw', 'lv2Withdraw', 'lv3Withdraw', 'activeMembers1', 'activeMembers2',
            'activeMembers3', 'totalInvestment', 'levelTotalCommission1', 'levelTotalCommission2',
            'levelTotalCommission3', 'totalLevelInvest1', 'totalLevelInvest2', 'totalLevelInvest3'
        ));
    }

    
    public function invite()
    {
     
        
        $data = $this->team()->getData(); 
        
        return view('app.main.invite', $data);
    }

   
    public function level($level = null)
    {
        if (!in_array($level, [1, 2, 3])) {
            return redirect()->route('user.team'); 
        }

        $user = Auth::user();
        $level_users = collect();
        
        if ($level == 1) {
            $level_users = User::where('ref_by', $user->ref_id)->get();
        } 
        elseif ($level == 2) {
            $first_level_ref_ids = User::where('ref_by', $user->ref_id)->pluck('ref_id')->filter();
            if ($first_level_ref_ids->isNotEmpty()) {
                $level_users = User::whereIn('ref_by', $first_level_ref_ids)->get();
            }
        } 
        elseif ($level == 3) {
            $first_level_ref_ids = User::where('ref_by', $user->ref_id)->pluck('ref_id')->filter();
            if ($first_level_ref_ids->isNotEmpty()) {
                $second_level_ref_ids = User::whereIn('ref_by', $first_level_ref_ids)->pluck('ref_id')->filter();
                if ($second_level_ref_ids->isNotEmpty()) {
                    $level_users = User::whereIn('ref_by', $second_level_ref_ids)->get();
                }
            }
        }
        
        return view('app.main.team.level', compact('level', 'level_users'));
    }
}